#include "MTSNDDViewer.h"
#include "MTFileList.h"
#include "IFileStream.h"
#include "MTExceptions.h"

MTSimpleResourceTemplate	MTSNDDViewer::kSNDDFormatTemplate =
{
	{
		ONI_RESOURCE_HEADER
		
		{	kTypeUInt32,							"Flags" },
		{	kTypeUInt32,							"Unknown" },
		{	kTypeUInt32,							"Size",			kTypeInfoResourceSize | kTypeInfoFlagUsesRawFile },
		{	kTypeUInt32,							"Data Offset",	kTypeInfoResourceOffset | kTypeInfoFlagUsesRawFile },
		
		{	0 }
	}
};

void MTSNDDViewer::DoExport(void)
{
	MTFileList			* fileList = GetOwningFileList();
	UInt8				* buf;
	UInt32				size = GetResourceEntryData(4);
	StandardFileReply	reply;
	OSErr				theErr;
	Str255				fileNameString;
	UInt32				flags;
	
	if(!size)
		return;
	
	flags = GetResourceEntryData(2);
	buf = fileList->theFile->LoadRaw(GetResourceEntryData(5), size);
	
	CopyCStringToPascal(viewerResourceName.c_str(), fileNameString);
	StandardPutFile("\pExport File:", fileNameString, &reply);
	
	if(reply.sfGood)
	{
		if(reply.sfReplacing)
		{
			theErr = FSpDelete(&reply.sfFile);
			if(theErr)
				throw MTOSFileException(theErr, "Error deleting old file");
		}
		
		theErr = FSpCreate(&reply.sfFile, 'TVOD', 'AIFF', reply.sfScript);
		if(theErr)
			throw MTOSFileException(theErr, "Error creating new file");
		
		IFileStream	stream;
		
		stream.OpenFile(&reply.sfFile);
		
		stream.WriteLong('FORM');			// 00
		stream.WriteLong(0x0032 + size);	// 04
		stream.WriteLong('AIFC');			// 08
		stream.WriteLong('COMM');			// 0C
		stream.WriteLong(0x0016);			// 10
		
		if(flags & 2)
			stream.WriteShort(2);			// 14
		else
			stream.WriteShort(1);			// 14
		
		if(flags & 2)
			stream.WriteLong(size / 68);	// 16
		else
			stream.WriteLong(size / 34);	// 16
		
		stream.WriteShort(16);				// 1A
		stream.WriteLong(0x400DAC44);		// 1C
		stream.WriteLong(0x00000000);		// 20
		stream.WriteShort(0x0000);			// 24
		stream.WriteLong('ima4');			// 26
		stream.WriteLong('SSND');			// 2A
		stream.WriteLong(0x0008 + size);	// 2E
		stream.WriteLong(0);				// 32
		stream.WriteLong(0);				// 36
		stream.WriteBuffer(buf, size);
		
		stream.CloseFile();
	}
	
	DisposePtr((Ptr)buf);
}